<?php
/**
 * Style registration - Auto-generated by build process.
 * Do not edit this file manually.
 *
 * Note: These styles can be overridden by calling jetpack_forms_override_style()
 * in lib/client-assets.php for complex cases (multiple files, conditional deps, etc.)
 *
 * @package jetpack_forms
 */

if ( ! function_exists( 'jetpack_forms_override_style' ) ) {
	/**
	 * Registers a style according to `wp_register_style`. Honors this request by
	 * deregistering any style by the same handler before registration.
	 *
	 * @param WP_Styles        $styles WP_Styles instance.
	 * @param string           $handle Name of the stylesheet. Should be unique.
	 * @param string           $src    Full URL of the stylesheet, or path of the stylesheet relative to the WordPress root directory.
	 * @param array            $deps   Optional. An array of registered stylesheet handles this stylesheet depends on. Default empty array.
	 * @param string|bool|null $ver    Optional. String specifying stylesheet version number, if it has one, which is added to the URL
	 *                                 as a query string for cache busting purposes. If version is set to false, a version
	 *                                 number is automatically added equal to current installed WordPress version.
	 *                                 If set to null, no version is added.
	 * @param string           $media  Optional. The media for which this stylesheet has been defined.
	 *                                 Default 'all'. Accepts media types like 'all', 'print' and 'screen', or media queries like
	 *                                 '(orientation: portrait)' and '(max-width: 640px)'.
	 */
	function jetpack_forms_override_style( $styles, $handle, $src, $deps = array(), $ver = false, $media = 'all' ) {
		$style = $styles->query( $handle, 'registered' );
		if ( $style ) {
			$styles->remove( $handle );
		}
		$styles->add( $handle, $src, $deps, $ver, $media );
	}
}

if ( ! function_exists( 'jetpack_forms_register_package_styles' ) ) {
	/**
	 * Register all package styles (simple cases only).
	 * Complex cases should be manually registered in lib/client-assets.php.
	 *
	 * @param WP_Styles $styles WP_Styles instance.
	 */
	function jetpack_forms_register_package_styles( $styles ) {
		// Load build constants
		$build_constants = require __DIR__ . '/constants.php';
		$default_version = ! SCRIPT_DEBUG ? $build_constants['version'] : time();
		$suffix          = SCRIPT_DEBUG ? '' : '.min';

		$styles_dir  = __DIR__ . '/styles';
		$styles_file = $styles_dir . '/registry.php';

		if ( ! file_exists( $styles_file ) ) {
			return;
		}

		$styles_data = require $styles_file;
		$plugin_dir  = dirname( __FILE__ );

		foreach ( $styles_data as $style_data ) {
			jetpack_forms_override_style(
				$styles,
				$style_data['handle'],
				$build_constants['build_url'] . 'styles/' . $style_data['path'] . $suffix . '.css',
				$style_data['dependencies'],
				$default_version
			);

			// Enable RTL support (WordPress automatically loads -rtl.css variant)
			$styles->add_data( $style_data['handle'], 'rtl', 'replace' );
			$styles->add_data( $style_data['handle'], 'suffix', $suffix );
		}
	}

	add_action( 'wp_default_styles', 'jetpack_forms_register_package_styles' );
}
