<?php

namespace SocialFeedsPro;

if(!defined('ABSPATH')){
	exit;
}

class Util{

	static function get_account_info($token){
		$settings_opts = get_option('socialfeeds_settings_option', []);
		$cache_duration = !empty($settings_opts['cache']['duration']) ? absint($settings_opts['cache']['duration']) : '3600';
		
		$cache_key = 'socialfeeds_ig_account_' . md5($token);
		$cached_info = get_transient($cache_key);
		
		if($cached_info !== false){
			return $cached_info;
		}

		$url = add_query_arg([
			'fields' => 'id,username,name,biography,profile_picture_url,followers_count,media_count',
			'access_token' => $token,
		], 'https://graph.instagram.com/me');

		$response = wp_remote_get($url);

		if(is_wp_error($response)){
			return [];
		}

		$data = json_decode(wp_remote_retrieve_body($response), true);

		$info = empty($data['error']) ? $data : [];
		
		if(!empty($info)){
			set_transient($cache_key, $info, $cache_duration);
		}
		
		return $info;
	}

	static function fetch_feed_data($access_token, $limit = 12){
		$token = trim(str_replace('Bearer', '', $access_token));
		$limit = max(1, intval($limit));

		$settings_opts = get_option('socialfeeds_settings_option', []);
		$cache_duration = !empty($settings_opts['cache']['duration']) ? absint($settings_opts['cache']['duration']) : '3600';

		$cache_key = 'socialfeeds_ig_feed_' . md5($token . $limit);
		$cached_data = get_transient($cache_key);

		if($cached_data !== false){
			return $cached_data;
		}

		$api = 'https://graph.instagram.com/v18.0';

		// Determine limit per page logic, similar to before
		$all_posts = [];
		$after = null;
		$last_paging = null;
		$per_page = 100; // API max
		$fetch_target = $limit;

		// We'll use /me/media for simplicity as basic display standard
		$endpoint_base = "$api/me/media";

		while(count($all_posts) < $fetch_target){
			$args = [
				'fields' => 'id,caption,media_type,media_url,thumbnail_url,permalink,timestamp,like_count,comments_count',
				'limit'  => $per_page,
				'access_token' => $token,
			];
			if($after){
				$args['after'] = $after; 
			}

			$url = add_query_arg($args, $endpoint_base);
			$response = wp_remote_get($url, ['timeout' => 30, 'sslverify' => true]);

			if(is_wp_error($response)){
				break; 
			}

			$data = json_decode(wp_remote_retrieve_body($response), true);

			if(empty($data) || !empty($data['error']) || empty($data['data'])){
				break;
			}

			$items = $data['data'];
			$all_posts = array_merge($all_posts, $items);

			$last_paging = isset($data['paging']) ? $data['paging'] : null;

			if(count($all_posts) >= $fetch_target){
				break; 
			}

			if(!isset($data['paging']['cursors']['after'])){
				$last_paging = null; // No more pages
				break; 
			}
			$after = $data['paging']['cursors']['after'];
		}

		$result_posts = array_slice($all_posts, 0, $limit);

		$result = [
			'data' => $result_posts,
			'paging' => $last_paging
		];

		if(!empty($result_posts)){
			set_transient($cache_key, $result, $cache_duration);
		}

		return $result;
	}
}